// adapted by Bob Hanson from http://threadbarecanvas.azurewebsites.net/jquery/bingo-card-javascript-and-jquery/
// 
// because there is no element "G" 
//
// just modify clues.js to create different Binko sets
//
// this can be done easily using the spreadsheet in this directory clues.xlsx
//
// BH 9/23/2016 5:45:04 AM

function help() {
 s = "You can play this game yourself just by clicking on squares. \n\
 Or, if you want to use this for a class, you can print a set of cards. \n\
 The key for the cards (the names you would pull out of a hat) is printed at the end.\n\n\
 BINKO by Bob Hanson, hansonr@stolaf.edu\n\n(because there is no element 'G')\n\n" 
 alert(s)
}

var usedArray = [], keyArray = [], answers = {};
var useMyList = false;
var BOTH = 0;
var FORWARD = 1;
var REVERSE = 2;
var mymode = BOTH;

function loadMyList() {
 useMyList = true;
 newCard();
}

function showMyList(doshow) {
 if (doshow){
 $('#mylist').show()
 $('#showlist').hide()
 $('#loadlist').show()
 } else {
 $('#mylist').hide()
 $('#showlist').show()
 $('#loadlist').hide()
 }
}

function init() {
  mymode = $("#mode")[0].selectedIndex;
  resetLinks();
  keyArray = [];
  if (useMyList) {
    title = ""
    getCluesFromList();
  } else if (document.location.href.indexOf("compounds2") >= 0) {
    title = "Compounds II"
    clues = clues4;
    $("#c2").css({color:"red"});
  } else   if (document.location.href.indexOf("compounds") >= 0) {
    title = "Compounds I"
    clues = clues2;
    $("#c1").css({color:"red"});
  } else   if (document.location.href.indexOf("elements2") >= 0) {
    title = "Elements and Ions II"
    clues = clues3;
    $("#e2").css({color:"red"});
  } else if (!useMyList) {
    $("#e1").css({color:"red"});
  }
  getListFromClues();
  getCluesFromList();
}

function resetLinks() {
  $(".newtype").css({color:"black"});
  $(".newtype").each(function() {$(this)[0].href=$(this)[0].href.split("&mode=")[0] + "&mode=" + mymode}); 
}


function getListFromClues() {
  var list = [];
  var s = "";
  for (var i = 0; i < clues.length; i++) {
    if (!clues[i] || clues[i].length < 2)
      continue;
    var pair = (clues[i][0] + "::" + clues[i][1]).replace(/–/g,'-');
    var p = ";" + pair + ";";
    if (s.indexOf(p) < 0) {
      list.push(pair);
      s += p;
    } 
  }
  list.sort();
  $("#mylist").val(list.join("\n"));
}

function getCluesFromList() {
  var s = $("#mylist").val().split("\n");
  clues = [];
  for (var i = 0; i < s.length; i++) {
    var c = s[i].trim();
    if (c.length == 0)
      continue;
    if (c.indexOf("::") < 0)
      c += "::" + c;
    clues.push(c.split("::"));
  }
}

function newCard() {
  init();
  fillCard();
  getKeys();
}

var pagebr = "<div class='breaker'></div>";

function printCards() {
  var n = prompt("How many cards do you need?", 20)
  if (!n)return
  init();
  for (var i = 0; i < n; i++) { 
    usedArray = [];
		fillCard();
    var card = pagebr + $("#card").html().replace(/background/g,'x');
    card = card.replace(/BINKO/, title + " (" + (i + 1) + ") <br>names: _______________________________");
    $("#printedCards").append(card);  
  }
  getKeys();
  window.print();
}

function getKeys() {
  var keys = [];
  var pt = 0;
  for (var i = 0; i < clues.length; i++) {
    if (keyArray[i]) {
      keys.push("<td>" + setClue(clues[i][keyArray[i] - 1]) + "</td>");
      if ((++pt) % 5 == 0)
        keys.push("</tr><tr>")
    }
  }
  $("#key").html(pagebr +"<table><tr>" + keys.join("") + "</tr></table>");
}

function fillCard(){
  usedArray = [];
  $("#card .cell").each(function(i,cell){fillCell(i, cell)})
}

var cluept = 0;
	 
function fillCell(i, cell){
 if (!cluept) {
   cluept = clues.length;
   usedArray = []; 
 }
 while (true) {
	 var number = Math.floor(Math.random()*clues.length);  		 
	 if(!usedArray[number])
    break;
 }
 var pt = (mymode == BOTH ? Math.floor(Math.random()*2)+ 1 : 3 - mymode);
 i = 3 - (keyArray[number] = (keyArray[number] || pt));
 var s = setClue(clues[number][i - 1]);
 $(cell).html(s);
 var s1 = setClue(clues[number][2 - i]);
 answers[s] = s1; 
 answers[s1] = s;
 usedArray[number] = true;
 cluept--;
}

function setClue(c) {
  
  if (c.indexOf("<") >= 0) 
    return c;
  var i = c.length;
  var chpt = -1;
  while (--i >= 0) {
    var ch = c[i];
    var isN = "1234567890".indexOf(ch) >= 0;
    var s = "";
    if ("-+".indexOf(ch) >= 0 || chpt == i && isN) {
      s = "sup";
      if (ch == '-')
        ch = "\u2013";
      if (chpt == -1)
        chpt = i - 1;
    } else if (isN) {
      s = "sub";
    }
    if (s)
      c = c.substring(0, i) + "<" + s + ">" + ch + "</" + s + ">" + c.substring(i + 1);
  }
  return c.replace(/\^/g,"");
}

$(document).ready(function(){
   
    mymode = parseInt(document.location.href.split("mode=")[1]) || 0;
    $('#mode')[0].selectedIndex = mymode;

   newCard();
 
	 $('#newCard').click(function(){
    newCard();
	 });
	 

	 $('#printCards').click(function(){
		printCards();
	 });

    $('td').hover(
      function() { 
      var me = this;
      if (!answers[me.innerHTML])
        return 
      me.style.backgroundColor = me.style.backgroundColor? "":"#A0A0A0";
      me.itimeout = setTimeout(
      function(){
      me.innerHTML = answers[me.innerHTML]
        //toggle.color = toggle.color? "":"#fff";
    }, 1000)}, function() {
      var me = this;
      me.style.backgroundColor = "";
      clearTimeout(me.itimeout);
    }
    );	 

    $('td').click(function(){
      if (!answers[this.innerHTML])
        return 
      this.innerHTML = answers[this.innerHTML]
        var toggle = this.style;
        toggle.backgroundColor = toggle.backgroundColor? "":"#A0A0A0";
      clearTimeout(this.itimeout);
        //toggle.color = toggle.color? "":"#fff";
    });	 

    
});

