program makemat (input,output);

{program to convert compact data to full matrix form}

const maxspecies = 1400; {change this to whatever you need}

type strng = string[30];
     numbers = array[1..maxspecies] of integer;

var filen : strng;
    file99,newfile,slashfile,indexfile : text;
    newindex, numberlist,countlist : numbers;
    let,corn,resp : char;
    a,x,c,i,k,cut : integer;
    b : real;
    dum,dum2 : string[7];
    newname : array [1..maxspecies] of string[7];
    stand : array[1..500] of string[5];
procedure readfile(var filen : strng);

begin
  writeln('Enter the name of the file that you want expanded ');
  readln(filen);
end;

procedure getnumbers(var numberlist,countlist : numbers);

 var i,j,k : integer;        {Procedure creates an internal spp list}
     dummy : string[5];      {that used by cutoff procedure and full}
        ch : char;           {matrix expansion option, etc}
        rl : real;

begin
  repeat {FOR A STAND}
     read(file99,dummy);
     writeln('Reading stand ',dummy);
     repeat {FOR ALL THE NUMBERS IN THE STAND}
        read(file99,i); {READ THE SPECIES NUMBER}
        writeln(i) ;
        if eoln(file99) then readln(file99);
        if i > 0 then begin
           j := 0;
           repeat
              j := j + 1;
           until (numberlist[j] = i) or (numberlist[j] < 0);
           if numberlist[j] < 0 then begin   {NUMBER WAS NOT FOUND ON LIST}
             numberlist[j] := i;
             countlist[i] :=0;
             numberlist[j+1] := -1;
           end;
             countlist[i] :=countlist[i]+1;
           read(file99,rl); {THIS IS THE VALUE, JUST THROW IT AWAY}

           if eoln(file99) then readln(file99);
        end;
     until i < 0;   {UNTIL ALL DONE WITH A STAND}
     {readln(file99);}

  until eof(file99);  {STAND}

end;

procedure sort (var numberlist,countlist : numbers);

var i,j,k,little : integer;

begin
  i := 0;
  repeat
    i := i + 1;
  until (numberlist[i+1] < 0);
  for j := 1 to i do begin
    for k := j to i do begin
      if numberlist[k] < numberlist[j] then begin
         little := numberlist[j];
         numberlist[j] := numberlist[k];
         numberlist[k] := little;
      end;
    end;
  end;
  i :=0;
  repeat
  i :=i+1;
  j := numberlist[i];
  k := countlist[j];
  countlist[i] :=k;
  until (numberlist[i+1] < 0);
end;

procedure cornell(numberlist,countlist : numbers);

var dummy: string[5];
    i,j,k,t,x :integer;
        z :real;
begin  {read file99, and write newfile w/ number at start of line}
writeln(newfile,'Cornell Format PEL Data File');
writeln(newfile,'(I5,6(1X,I5,1X,F5.1))                                                6');
      x :=0;
  repeat
    read(file99,dummy);
      x :=x+1;
      stand[x]:=dummy; {stand x used in main prog for stand names}
      stand[x+1]:='end';
    writeln('Reformatting stand  ',dummy);
    write(newfile,x:5);
         j := -1;
     repeat
      read (file99,i);
       if eoln(file99) then readln(file99);
       if i > 0 then begin
            k :=0;
            repeat
            k :=k+1;
            t :=countlist[k];
            until (numberlist[k] = i);
            if t > cut then begin
                j := j+1;
                if j = 6 then begin  {COUNTER FOR NUMBER OF SPP PAIRS/LINE}
                writeln(newfile);
                write(newfile,x:5);
                j := 0;
                end;
                read(file99,z);
                write(newfile,k:6,z:6:1);
               end
               else begin
               read(file99,z); {read value and throw away}
            end;
           end;
       until (i < 0); {just read and wrote a stand}
     if i < 0 then writeln(newfile);
  until eof(file99);
end; {of cornell subprogram}
{species and stand names added in main program loop}

procedure matrix(numberlist: numbers);

var dummy : string[5];
     i,j,k : integer;
        z,d : real;
    species : numbers;
    amount  : array [1..maxspecies] of real;

begin
   z := 0;
   write(newfile,'spp # '); {Just writing what the matrix will hold}
   i := 1; k := 0;
   repeat
     if countlist[i] > cut then begin
     write(newfile,numberlist[i]:7);
     if k > 8 then begin        {COUNTER FOR SPP INDEX AT TOP OF OUTPUT}
       k := -1;                 {FILE.  GIVES 10 SPP/ROW AS NOW SET}
       writeln(newfile);
       write(newfile,'      ');
     end;
     k := k + 1;
     end;
     i := i + 1;
   until (numberlist[i]< 0);

  writeln(newfile);writeln(newfile);

   repeat {for all of the stands in the file}
     read(file99,dummy);
     writeln('Expanding stand ',dummy);
     write(newfile,dummy);

     for j := 0 to 6 - ord(dummy[0]) do write(newfile,' ');

     i := 1;

     repeat  {reads in info for a stand}
       read(file99,j);
       if eoln(file99) then readln(file99);
       if j > 0 then begin
         species[i] := j;
         read(file99,amount[i]);
         if eoln(file99) then readln(file99);
         i := i + 1;
       end
       else begin
        species[i]:= -99;
       end;
     until (j < 0); {just read in a stand}
     i := 1; {counter for numberlist which keeps track of total species}
     k := -1; {counter for length of line}
     repeat  {writes out the matrix}
        j := 0;
        repeat
          j := j + 1;
          until (numberlist[i]=species[j]) or (species[j] < 0);
       if countlist[i] > cut then begin
          k :=k+1;
        if species[j] < 0 then write(newfile,z:6:1) else
          write(newfile, abs(amount[j]):6:1);
        end;
        i := i +1;
       if numberlist[i] > 0 then begin
        if k > 8 then begin    {COUNTER FOR NUMBER OF SPP/ROW IN CONVERTED}
          k := -1;             {FILE. CURRENTLY SET TO GIVE 10 SPP/ROW}
          writeln(newfile);
          write(newfile,'       ');
        end;
       end;
     until (numberlist[i] < 0);

     writeln(newfile);

   until (eof(file99));
end;

{    PROGRAM MATRIX (written by Paul Umbanhowar, modified by Charles   }
{     E. Umbanhowar Jr. 1990.   ver 4.0 June 1990                      }
{    Program takes Wisconsin Plant Ecology ASCII files and converts    }
{    them to either  CORNELL or "PCORD" data formats.  Program is      }
{    simple in construction and will not write format statements in    }
{    this version.   Note that cutoff loops for the different programs }
{    all work the same way.  To change number of columns reset count   }
{    loops in subroutines matrix and/cornell.                          }
  begin
  writeln('This program converts PEL files to either fully filled or');
  writeln('Cornell format matrices.');
  writeln;
  writeln('   Your data file must have data on the first line and ');
  writeln('   have data on the last line.  No extra lines are permitted.');
  writeln('      Use lower case letters when using the program.');
  writeln('        See PEL files writeup for further details');
  writeln;
  writeln(' Name of File to be Converted?');
  writeln;
  readln(filen);
  assign(file99,filen);
  reset(file99);
  numberlist[1] := -1;
  getnumbers(numberlist,countlist); {FINDS ALL THE DIFFERENT NUMBERS IN THE FILE}
  sort(numberlist,countlist); {SORTS THE LIST OF SPECIES}
  reset(file99);
  writeln('Name of new file to be created?');
  readln(filen);
  assign(newfile,filen);
  rewrite(newfile);
   repeat
   writeln;
   writeln('Do you want to expand matrix fully or convert to Cornell');
   writeln('Compact Data Format?  (f or c) ');
   readln(corn);
   until (corn='c') or (corn='f');
   if corn='c' then cut :=0;
   if corn='f' then begin
   repeat
   writeln;
   writeln('Eliminate rare species?  (y/n)');
   readln(resp);
   until (resp='y') or (resp='n');
   if resp='n' then cut := 0
   else begin
   writeln;
   writeln(' Minimum occurrence cutoff? ( Species occurring in fewer');
   writeln(' stands than you input will be eliminated.)');
   readln(cut);
   cut := cut - 1;
   end;
  end;
  if corn = 'c' then begin
  cornell(numberlist,countlist); {WRITE COMPACT MATRIX}
  end
  else begin
  matrix(numberlist); {WRITE THE MATRIX}
  close(file99);
  end;
  if (corn='f') then begin
  writeln('Do you wish to add a list of species abbreviations (y/n)?');
  readln(let);
  end;
   if (let = 'y') or (corn='c') then begin
    writeln('Enter name of species index file (names.key)');
    readln(filen);
    a := 1;
    assign(indexfile,filen);
    reset(indexfile);
    repeat
      readln(indexfile,c,dum);
      newindex[a] := c ; newname[a] := dum;
      a := a + 1;
    until eof(indexfile);
    newindex[a] := -1;
    close(indexfile);
    {at this point you have the names and corresponding codes}
    c := 1;

{Species Names if Full Matrix Format Selected}

    if corn = 'f' then begin
    repeat {for all the species in numberlist}
      a := 0;
      repeat {for all the species in newindex}
        a := a + 1;
      until newindex[a] = numberlist[c];
      if countlist[c] > cut then writeln(newfile,newname[a]);
      c := c + 1;
    until numberlist[c] < 0;
    end

{Add Species Names if Cornell Format Selected}

   else begin
     writeln(newfile); {Blank Line required by Cornell Programs}
     k:= -1;
    repeat {for all species in numberlist}
      a:= 0;
      repeat {for all species in newindex}
      a:= a+1;
      until newindex[a] = numberlist[c];
      if k > 8 then begin
        k:= -1;
        writeln(newfile);
        end;
     if countlist[c] > cut then write(newfile,newname[a]:8);
     if countlist[c] >cut then k:=k+1;
    c:= c+1;
    until numberlist[c] < 0;
    end;
 if corn ='c' then begin  {Adds stand names to bottom of Cornell Format}
     writeln(newfile);
     x:= 0;
     k:= 0;
     repeat
      x :=x+1;
      write (newfile,stand[x]:8);
      if k > 8 then begin
        k := -1;
        writeln(newfile)
        end;
      k := k+1;
     until stand[x+1] ='end';
  end;
  end;
  close(newfile);
end.