gnuplot.init('gnuplot.js');
gnuplot.text = "";
gnuplot.files = [];

var lastDataValue = '';
var lastPlotValue = '';
var dct = 0;
var pct = 0;
var rt = 0;

function updateListing(updateImages) {
	if (!gnuplot.worker)
		return;
	gnuplot.getListing(function(e) {
		var l = e.content;
		gnuplot.lastListing = l;
 /*   
		$("#listing").empty();
		var html_l = "";
		$("#vfsHeading").html("VFS contents (" + l.length + ")");
		for (var name in l)
			html_l += "<a href='#' onclick='gnuplot.getFile(\"" + l[name] + "\", function(evt) {downloadAsFile(\"" + l[name] + "\", new Uint8Array(evt.content).buffer);})' value='" + l[name] + "' class='list-group-item'><span onclick=\"deleteFile(event, '" + l[name] + "')\" class=\"glyphicon glyphicon-minus-sign\">&nbsp;</span>" + l[name] + "</a>";
		$("#listing").html(html_l);
*/
		// Search for an image
		if (!updateImages)
			return;
		for (var nameidx in l) {
			var name = l[nameidx];
			if (name.search(".png") > 0)
		        gnuplot.getFile(name, function(e) {
		            if (!e.content) {
		                gnuplot.onError("Output file "+name + " not found!");
		                return;
		            }
		            toGnuplotImage(e.content, "image/png");
		        });
			if (name.search(".jpg") > 0 || name.search(".jpeg") > 0)				
		        gnuplot.getFile(name, function(e) {
		            if (!e.content) {
		                gnuplot.onError("Output file "+name + " not found!");
		                return;
		            }
		            toGnuplotImage(e.content, "image/jpeg");
		        });
			if (name.search(".gif") > 0)
		        gnuplot.getFile(name, function(e) {
		            if (!e.content) {
		                gnuplot.onError("Output file "+name + " not found!");
		                return;
		            }
		            toGnuplotImage(e.content, "image/gif");
		        });
			if (name.search(".svg") > 0)
		        gnuplot.getFile(name, function(e) {
		            if (!e.content) {
		                gnuplot.onError("Output file "+name + " not found!");
		                return;
		            }
		            toGnuplotImage(e.content, "image/svg+xml");
		            var gpi = $("#gnuplotImage")[0];
		            var canv = $("#gnuplotCanvas")[0];
		            //gpi.style.width="100%";
		            
		            setTimeout(function() {
			            canv.width = gpi.width + 140;
			            canv.height = gpi.height+140;
		            
		            setTimeout(function() {
			            var ctx = canv.getContext("2d");
			            ctx.drawImage(gpi, 0, 0);
			            $("#gnuplotRaster")[0].src = canv.toDataURL("image/png");
			            gpi.style.width="100%";
		            }, 200)}, 200);
		        });
		}

	});
}
updateGraph = function() {
		gnuplot.putFile("script.txt", $("#plotTA").html());
    run();
};


function toGnuplotImage(data, mimestring) {
    var img = document.getElementById('gnuplotImage');
    try {
        var ab = new Uint8Array(data);
        var blob = new Blob([ab], {"type": mimestring});
        window.URL = window.URL || window.webkitURL;
        var urlBlob = window.URL.createObjectURL(blob);
        img.src = urlBlob;
        return urlBlob;
    } catch (err) { // in case blob / URL missing, fallback to data-uri
        if (!window.blobalert) {
            alert('Warning - your browser does not support Blob-URLs, using data-uri with a lot more memory and time required. Err: ' + err);
            window.blobalert = true;
        }
        var rstr = '';
        for (var i = 0; i < e.content.length; i++)
            rstr += String.fromCharCode(e.content[i]);
        img.src = 'data:'+mimestring+';base64,' + btoa(rstr);
    }
};

function run() {
	gnuplot.text = "";
	$("#outDiv").addClass("hidden");
    // "upload" files to worker thread
    for (var f in gnuplot.files)
        gnuplot.putFile(f, gnuplot.files[f]);
	
	gnuplot.run(["script.txt"], function(e) {
		updateListing(true);
	});
};

//arrayBuffer to array for JSON.stringify
function abToArray(ab) {
	var bb = new Uint8Array(ab);
	var arr = new Array(bb.length);
	for (var i=0; i < bb.length; i++)
		arr[i] = bb[i];
	return arr;
}

//array to ab 
function arrayToAb(arr) {
	return new Uint8Array(arr).buffer;
}


gnuplot.onOutput = function(text) {
	gnuplot.onError(text);
};

gnuplot.onError = function(text) {
	$("#outDiv").removeClass("hidden");
	gnuplot.text = gnuplot.text + "<br>" + text;
	$("#gnuplotOut").html(gnuplot.text);
};


/*
files = {};
if (localStorage["gnuplot.files"])
    files = JSON.parse(localStorage["gnuplot.files"]);
for (var key in files)
    gnuplot.onOutput("Found locally stored file: " + key + " with " + files[key].length + " bytes.");
var runScript = function() {
    var editor = document.getElementById('gnuplot');   // textarea
    var start = Date.now();
    // "upload" files to worker thread
    for (var f in files)
        gnuplot.putFile(f, files[f]);

    gnuplot.run(editor.value, function(e) {
        gnuplot.onOutput('Execution took ' + (Date.now() - start) / 1000 + 's.');
        gnuplot.getFile('out.svg', function(e) {
            if (!e.content) {
                gnuplot.onError("Output file out.svg not found!");
                return;
            }
            var img = document.getElementById('gnuimg');
            try {
                var ab = new Uint8Array(e.content);
                var blob = new Blob([ab], {"type": "image\/svg+xml"});
                window.URL = window.URL || window.webkitURL;
                img.src = window.URL.createObjectURL(blob);
            } catch (err) { // in case blob / URL missing, fallback to data-uri
                if (!window.blobalert) {
                    alert('Warning - your browser does not support Blob-URLs, using data-uri with a lot more memory and time required. Err: ' + err);
                    window.blobalert = true;
                }
                var rstr = '';
                for (var i = 0; i < e.content.length; i++)
                    rstr += String.fromCharCode(e.content[i]);
                img.src = 'data:image\/svg+xml;base64,' + btoa(rstr);
            }
        });
    });
};
// set the script from local storage
if (localStorage["gnuplot.script"])
    document.getElementById('gnuplot').value = localStorage["gnuplot.script"];
scriptChange();
function handleFileSelect(evt) {
    var _files = evt.target.files; // FileList object

    // files is a FileList of File objects. List some properties.
    var output = [];
    for (var i = 0, f; f = _files[i]; i++) {
        output.push('<li><strong>', escape(f.name), '</strong> (', f.type || 'n/a', ') - ',
                f.size, ' bytes, last modified: ',
                f.lastModifiedDate ? f.lastModifiedDate.toLocaleDateString() : 'n/a',
                '</li>');
        (function() {
            var reader = new FileReader();
            var fname = f.name;
            reader.onloadend = function(e) {
                if (e.target.result) {
                    gnuplot.onOutput(fname + ": Read success - storing in browser. " + e.target.result.length);
                    files[fname] = e.target.result;
                    localStorage["gnuplot.files"] = JSON.stringify(files);
                }

            };
            reader.readAsText(f);
        })();
    }
    document.getElementById('list').innerHTML = '<ul>' + output.join('') + '</ul>';
}
document.getElementById('files').addEventListener('change', handleFileSelect, false);

*/
