//bob hanson hansonr@stolaf.edu 
//6:36 AM 8/22/01
// revised 9/4/2017 8:58:32 PM
msc="http://www.mnsoaringclub.com/"
remdeweather="http://www.soarmn.com/soaring_links/weather.htm"
purdueweather="http://weather.unisys.com/"
woptions="menubar,scrollbars,resizable,alwaysRaised"
dataserver=(document.URL.indexOf("file:///")>=0?"http://127.0.0.1":"http://ptm237.chem.stolaf.edu")+"/execute/windata"
gnuserver="http://www.stolaf.edu/cgi-bin/gnuplot.pl"
testserver="http://www.stolaf.edu/cgi-bin/test.pl"
Colors=new Array(1,9,8,5,7)
ColorPt=new Array(1,0,2)
icolorwind=4
icolortangent=2
icolorbestLD=0
icolorminsink=1

//unit conversions

function toKelvin(stype){
 if(stype=="R")return 5/9
}

function toRankin(stype){
 if(stype=="K")return 9/5
}

function toFeet(stype){
 if(stype=="ft")return 1
 if(stype=="in")return 1/12
 if(stype=="m")return 1000/25.4/12
 if(stype=="km")return 1E6/25.4/12
 return 0
}

function toMeters(stype){
 if(stype=="in")return 1/(1000/25.4)
 if(stype=="ft")return 1/(1000/25.4/12)
 if(stype=="m")return 1
 if(stype=="km")return 1000
 return 0
}

function toMillibars(stype){
 if(stype=="atm")return 1013.25
 if(stype=="inHg")return 1013.25/29.92
 if(stype=="mmHg"||stype=="torr")return 1013.25/760
 if(stype=="mbar")return 1
}

function toInchesMercury(stype){
 if(stype=="atm")return 29.92
 if(stype=="inHg")return 1
 if(stype=="mmHg"||stype=="torr")return 29.92/760
 if(stype=="mbar")return 29.92/1013.25
}

function toPascals(stype){
 if(stype=="N/m2"||stype=="Pa")return 1
 if(stype=="kg/m2"||stype=="kg")return 9.80665
 if(stype=="lb/ft2"||stype=="lb")return 47.88026
 if(stype=="inHg")return 1013/29.92
 return 0
}

function toKnots(stype){
 if(stype=="knots")return 1
 if(stype=="ft/s")return 0.592483786237
 if(stype=="km/h")return 0.5399568
 if(stype=="m/s")return 1.94384617179
 if(stype=="mph")return 0.86897624
 if(stype=="ft/min")return 0.009874730161
 return 0
}

function toPerSecond(stype){
 if(stype.indexOf("/s")>=0)return 1
 if(stype.indexOf("/min")>=0)return 1/60
 return 1/3600
}

function toVtrue(){return 1/sqrtsigma}

function toVequiv(){return sqrtsigma}

sigma=1  // sqrt(rho/rho0)
sqrtsigma=Math.pow(sigma,0.5) //multiplied by Vtrue gives Vequiv
da=0
dau="ft"
stdtemp0=518.67   //Rankin (oF + 460)
stdpres0=29.92    //inches of mercury
stddens0=0.002378 //slugs per cubic ft
stdtemp=stdtemp0
stdpres=stdpres0

//not using lapse rates
//tlapse=-0.0065/toFeet("m")    //(oC or K) per m
//plapse=-1/1000 // inHg per 1000 ft

ismetric=false

function getsigma(densalt){
 /*
 densalt is in feet this corrolates
 with a specific standard pressure and temperature 
 */ 
 theta=1.0-densalt/145442
 delta=Math.pow(theta,5.255876)
 sigma=Math.pow(theta,4.255876)
 stdtemp=stdtemp0*theta
 stdpres=stdpres0*delta
 stddens=stddens0*sigma

 //stdtemp=stdtemp0+tlapse*densalt
 //stdpres=stdpres0+plapse*densalt
 //sigma=(stdpres/stdpres0)/(stdtemp/stdtemp0)

 sqrtsigma=Math.pow(sigma,0.5)
}

/* update for density altitude 11:15 PM 8/16/01

  added toVtrue(), toVequiv()

  Note that all raw values, in Vi[] and Vsi[], are INDICATED 
  and positive and saved in knots.

  This is standard for polars, but WINDS, of course, are NOT INDICATED.
  Rather, winds are TRUE. Also, the concept of Vsi is rather bizarre, as
  there is no "indicator" for Vsi (certainly not a variometer) as there
  is for airspeed, and what would you ever do with "indicated Vs," anyway.
  Certainly we expect the y-axis to show true values. Thus, although 
  polars are discussed in terms of Vi and "Vsi," we choose here to 
  present them as V and Vs (both TRUE).

*/

function getdainfo(){return da + " " + dau + " ("+roundoff(stdtemp*toKelvin("R")-273.15,1)+" oC, "+(ismetric?roundoff(stdtemp*toKelvin("R"))+"K":roundoff(stdtemp-459.6,1)+ " oF")+" and "+(ismetric?roundoff(stdpres*toPascals("inHg"))+" hPa":roundoff(stdpres,2)+" inHg") +")"}

going=false

function newwingloading(){
 if(going)return 0
//here user has switched grosswt for wingloading
 e=getvalue("wingloading")
 var stype=getselectof("selloadtype")
 var wu=getselectof("wu")
 if(wu=="rel to 1")return 1
 if(getselectof("selloadtype")=="grosswt"){
  if(!wtOK)return usr.selloadtype.selectedIndex=0
  e=e/defwingload*toPascals(wu)/toPascals(defwingunits)*defgrosswt  
 }else{
  if(!wingOK)return usr.selloadtype.selectedIndex=1
  e=e/defgrosswt*toPascals(wu)/toPascals(defwtunits)*defwingload
 }
 e=roundoff(e,(e<10?2:0))
 usr.wingloading.value=e
 setwingunits()
 getinfo()
 showone()
 doGraph();
 return 1
}

function newinfo(){
 if(setinfosource(1))return
 loadfromdata()
}

function loadfromdata(){
 sloadinfo=getwinginfo()
 showone()
}

TH="<th nowrap>"
THC="<th nowrap align=center>"
function THN(n){return "<th nowrap align=center "+(n<0?"row":"col")+"span="+Math.abs(n)+">"}
TD="<td nowrap>"
TDC="<td nowrap align=center>"
TR="<tr>"

function doload(){
 usr=document.info
 var s=document.location.href
 s=s.toUpperCase()
 islocal=(s.indexOf("FILE:///")==0)
 var i1=(typeof(navigator.mimeTypes["application/x-windata"])!="undefined")
 i2=(i1
  && navigator.appName=="Netscape" 
  && navigator.appVersion.indexOf("Win")>0 
  && navigator.appVersion.indexOf("3.")>=0
  )
  defdisplaytype=1
  usr.sdtype.selectedIndex=defdisplaytype


xyinfo="parent.CALC_xy.document.info"
liftdirec=1 //1=lift; -1=sink
relativeloadmax=3 //arbitrary
Vi=new Array()
Vsi=new Array()
A=new Array()
C=new Array()
P=new Array()
sabc=""
sdsrc=""
sloadinfo=""
sdata=""
havesetinfo=0
gf=1
hwkn=0 //headwind in knots
lkn=0 //lift in knots
aspectratio=1.25
pt=0
loadtype="wingload"
wingunits="N/m2"
wingload=350 
wingOK=true
grosswt=0
wtunits="lb"
wtOK=0
defwingload=350
defgrosswt=0
defwingunits="N/m2" //Pascals
defwtunits="kg"
vunits="km/h"
vismetric=0
vsismetric=0
vsunits="m/s"
vcruise=-1e99
fvbank=1
fvsbank=1
v2kn=1
l2kn=1
multitype=-1
multipt=finditem(usr.thisaction,"dograph(0)",0)
setTimeout('loadcookie()',200)
}

function loadit(mode){
var s=""
if(mode==1) s="spd2flyt.htm"
if(mode==2) s="spd2fly.htm"
if(mode==3) s=purdueweather
if(mode==4) s=remdeweather
if(mode==5) s="densalt.htm"
if(mode==6) s=msc
if(s.length) msgwindow=window.open(s)
return 0
}

function setbyname(swhat,sval,sitem){
 if(swhat=="test")return
 if(!iselement(usr,swhat))return
 if(sitem!="null" && sitem!="undefined")eval("usr."+swhat+".selectedIndex='"+sitem+"'")
 if(sval!="null" && sval!="undefined")eval("usr."+swhat+".value='"+sval+"'")
}
//window utilities
function iselement(frm,swhat){
 for(var i=0;i<usr.elements.length;i++){
  if (usr.elements[i].name==swhat)return 1
 }
 return 0
}
function setcookie(mode){
 if(mode==-1)showcookie()
 xy=parent.CALC_xy.document.info
 var sexp="Saturday, 31-Dec-2050 12:00:00 GMT"
 for (var i=0;i<usr.elements.length;i++){
  document.cookie="C["+i+"]=\"setbyname('"+usr.elements[i].name+"','"+usr.elements[i].value+"','"+usr.elements[i].selectedIndex+"')\";expires="+sexp
 }
 var c=xy.data
 var s="doship=\"setship('"+c[c.selectedIndex].text+"')\";expires="+sexp
 document.cookie=s
 var sexp="Friday, 30-Dec-2039 12:00:00 GMT"
 if(mode==-1){s=document.cookie;document.cookie=s+";expires="+sexp}
 if(mode)showcookie()
}
function loadcookie(){
eval(document.cookie)
for (var i=0;i<C.length;i++)eval(C[i])
}

function showcookie(){alert(document.cookie)}
function put(sline){
  $("#results").html(sline);
}
function dump(){
 var s=""
 for (var i=0;i<arguments.length;i++)s+=arguments[i]+" "
 put("<HTML><small>"+s+"<br></small></html>")
}

function loadmany(){waitforload("setinfosource(1)",parent.CALC_xy,"manymany.htm")}
function selectof(c){return c[c.selectedIndex].value}
function getselectof(swhat){return selectof(eval("document.info."+swhat))}
function textof(swhat){var c=eval("document.info."+swhat);return c[c.selectedIndex].text}
function getvalue(swhat){return eval(fixleading0(eval("document.info."+swhat+".value")))}
function findvalue(sform,sname){
 var form=eval(sform)
 var i=findname(form,sname)
 return(i<0?"0":form.elements[i].value)
}
function doshow(){
 xy=parent.CALC_xy.document.info
 if(xy.abc.value.length==0)setinfosource(0)
 if(eval(getselectof("thisaction")))setcookie(0)
}

function findname(form,sname){
 for(var i=0;i<form.elements.length;i++){
  if(form.elements[i].name==sname)return i
 }
 return -1
}

function finditem(control,sitem,idef)//looks in a select control for sitem
{
 for (var i=0;i<control.length;i++){
  var s=control.options[i].value  
  if(s.indexOf(sitem)==0)return i
 }
 return idef
}

function fileof(s){
 var sfile=s
 var i=sfile.indexOf("/")
 while (i>=0){
  sfile=sfile.substring(i+1,sfile.length)
  i=sfile.indexOf("/")
 }
 return sfile
}

//math,string utilities

function fixleading0(snum) //NOT octal!
{
 var i=0
 while(snum.charAt(i)=="0" && i<snum.length-1)i++
 return(i==0?snum:snum.substring(i,snum.length))
}

function roundoff(x,ndec){
 //round x to ndec decimal places
 if(ndec==null||ndec==0)return Math.round(x)+""
 var xstring=x+" "
 var i=xstring.indexOf("E")
 if(i>0) return x
 i=xstring.indexOf("e")
 if(i>0) return x
 i=xstring.indexOf(".")
 if(i<0) 
 {
  xstring=x+"."+"00000"+" "
  i=xstring.indexOf(".")
 }
 if(ndec==0){
  xstring=xstring.substring(0,i)
 }else{
  xstring=xstring.substring(0,i)+"."+xstring.substring(i+1,i+1+ndec)
 }
 if(i==0) xstring="0"+xstring
 if(xstring.indexOf("-.")==0)xstring="-0"+xstring.substring(1,xstring.length)
 if(xstring=="-")xstring="0"
 return xstring
}

function strsub(ssub,ch1,ch2){
 if(ch2!=""){if(ch2.indexOf(ch1)>=0) return ssub}
 var s=ssub
 var i=s.indexOf(ch1)
 while (i>=0){
  s=s.substring(0,i)+ch2+s.substring(i+ch1.length,s.length)
  i=s.indexOf(ch1)
 }
 return s
}

function strclean(sclean) 
{
 //tabs and commas to space and leading spaces removed
 var s=sclean
 s=strsub(s,"\n"," ")
 s=strsub(s,"\r"," ")
 s=strsub(s,"\f"," ")
 s=strsub(s,"\t"," ")
 s=strsub(s,"\q"," ")
 s=strsub(s,","," ")
 s=strsub(s,"  "," ")
 var i=0
 while (s.charAt(i)==" ")i++
 return(i==0?s:s.substring(i,s.length))
}

function angleof(a,b,c,indegrees) //cos law: c^2=a^2+b^2-2abcosTHETA
{
 //return of -99999 means error
 if(Math.abs(a+b-c)<0.000001) return 180
 if(Math.abs(a+c-b)<0.000001) return 0
 if(Math.abs(b+c-a)<0.000001) return 0
 var e=a*b
 if(e==0) return -99999
 var e=(a*a+b*b-c*c)/(2*Math.abs(e))
 if(e<-1 || e>1)return -99999
 var theta=Math.acos(e)
 if(indegrees) return roundoff(deg(theta))
 return theta
}

function oppsideof(a,b,theta,isdegrees){
 var rtheta=(isdegrees?rad(theta):theta)
 var e=a*a+b*b-2*Math.abs(a*b)*Math.cos(rtheta)
 if(e<0) return -99999
 return Math.pow(e,.5)
}

function adjsideof(b,c,theta,isdegrees){
 if(isdegrees && theta==180 || theta==0) return Math.abs(c-b)
 if(isdegrees && theta==60 && b==c) return b
 var rtheta=(isdegrees?rad(theta):theta)
 var e=Math.sin(rtheta)
 e=c*c-b*b*e*e
 if(e<0) return -99999
 var e1=b*Math.cos(rtheta)
 e=Math.pow(e,.5)
 if(e<e1)return e1-e
 return e1+e
}

function deg(rtheta){return rtheta/Math.PI*180}

function rad(theta){return theta/180*Math.PI}

function getxy(sxy){
 //globals sx and sy parsed from sxy
 sx=""
 sy=""
 if(sxy=="") return ""
 var s=sxy
 var i=s.indexOf(" ")
 if(i>0){
  sx=s.substring(0,i)
  s=s.substring(i+1,s.length+1)
 }else{
  s=""
 }
 i=s.indexOf(" ")
 if(i>0){
  sy=s.substring(0,i)
  s=s.substring(i+1,s.length+1)
 }else{
  sy=s
  s=""
 }
 return s
}

function plotxy(x,y,ch){return roundoff(x,3)+sep+roundoff(y,4)+(iswindata?","+ch+",":"")+nl}

function waitforload(sexec,wnd,loc){
 if(loc!="-"){
  if(loc.length)wnd.document.location=loc
  wndloading=wnd
 }else{
  var s=wndloading.status
  if(wndloading.status==null || s.length==0) return eval(sexec)
 }
 return setTimeout("waitforload('"+sexec+"',0,'-')",200)
}

//remotely called

function setinfosource(isdefault){
 //called remotely from CALC_xy
 havesetinfo=1
 pt=0
 xy=parent.CALC_xy.document.info
 usr=parent.CALC_input.document.info
 sabc=(isdefault?selectof(xy.data):xy.abc.value)
 if (sabc=="")sabc=selectof(xy.data)
 xy.abc.value=sabc
 xy.srcname.value=xy.data[xy.data.selectedIndex].text
 if(sabc.indexOf("htm")>=0){
  xyinfo="parent.CALC_data.document.info"
  xy.srcinfo.value=xyinfo
  waitforload("loadfromdata()",parent.CALC_data,sabc)
  return true
 }else{
  xyinfo="parent.CALC_xy.document.info"
  xy.srcinfo.value=xyinfo
  return false
 }
}


//soaring utilities

function fixwind(theta)  //-10 to 350, 10 to 010
{
 var s="000"+((roundoff(theta+720)) % 360)
 return s.substring(s.length-3,s.length)
} 

function iofvi(i0,vi){
 //vi is indicated
 var e=vi*v2kn/fvbank
 for(var i=i0;i<=pt;i++){if(Vi[i]>=e) return i}
 return 0
}

function vofsink(vsink){
//returns highest vi (equiv user units) corresponding to the designated sink
//sink rate is true and positive (user units); Vsi[] values are equivalent and positive

 var e=vsink*l2kn/fvsbank*toVequiv()
 var vi=0
 if(Vsi[pt]>e){
  for(var i=pt-1;i>0;i--){
   if(Vsi[i]<e)break
  }
  vi=(i?(Vi[i]+Vi[i+1])/2:0)
 }else{
  vi=0
 }
 return vi*fvbank/v2kn
}

function vofdoverl(doverl,vsink){
//returns highest vi (user units) corresponding to the designated 1/(L/D) when sink
//sink rate is true and positive (user units), but Vsi[] values are equivalent and positive

 var e=vsink*l2kn/fvsbank*toVequiv()
 var vi=0
 if((e+Vsi[pt])/Vi[pt]>doverl){
  for(var i=pt-1;i>0;i--){
   if((e+Vsi[i])/Vi[i]<doverl)break
  }
  vi=(i?(Vi[i]+Vi[i+1])/2:0)
 }else{
  vi=0
 }
 return vi*fvbank/v2kn
}

function vofbestld(vsink){
//returns bestL/D vi (user units) 
//sink rate is true and positive (user units), but Vsi[] values are equivalent and positive

 var e=vsink*l2kn/fvsbank*toVequiv()
 var vi=0
 var doverlmin=1e99
 var imin=0
 var doverl=0
 for(var i=pt-1;i>0;i--){
	doverl=(e+Vsi[i])/Vi[i]
	if(doverl<doverlmin){
		doverlmin=doverl
		imin=i
	}
 }
 return Vi[imin]*fvbank/v2kn
}

function getdataxy()//interprets xy data
{
 var sdata0=sdata
 sdsrc=parent.CALC_xy.document.location.pathname
 sdsrc=fileof(sdsrc)
 var sdigit="0123456789.-+"
 var pt0=pt
 pt=0
 if(parent.CALC_xy.document.forms.length>0){
  var sp=0
  var sxy=""
  var stemp=""
  var s=findvalue("parent.CALC_xy.document.info","srcinfo")
  if(s!="0")xyinfo=s
  var s=findvalue("parent.CALC_xy.document.info","srcname")
  if(s!="0")sdsrc=s
  var s=findvalue(xyinfo,"srcname")
  if(s!="0")sdsrc=s
  sdata=findvalue(xyinfo,"xy")
  if(sdata=="0")sdata=getabc()
  if(sdata==sdata0 && pt0!=0) return pt0
  var sxy=strclean(sdata) 
  var s=sxy
  s=getxy(s)
  var sx1=sx.substring(0,1)
  if(sdigit.indexOf(sx1)<0){
   if(toKnots(sx)>0){
    vunits=sx
    if(toKnots(sy)>0)vsunits=sy  
   }
  }
  vfactor=toKnots(vunits)
  vsfactor=toKnots(vsunits)
  while (sxy!=""){
   sxy=getxy(sxy)
   var sx1=sx.substring(0,1)
   if(sdigit.indexOf(sx1)<0) sx=""
   if(sx!=""){
    pt=pt+1
    Vi[pt]=eval(sx)*vfactor
    Vsi[pt]=Math.abs(eval(sy)*vsfactor)
   }
  }
 }

//at this point Vi[] and Vsi[] are EQUIVALENT

 if(pt>0) return pt
 alert("No sailplane data are loaded.")
 loadmany()
 return 0
}


//plotting 

function hwmax(stype){return(stype=="ft/min"?0.25:25)}
function liftstepof(stype){return(stype=="ft/min"?100:(stype=="m/s"?0.5:1))}

function xlimits(stype,isR,iswindata){
 var i=xrange(stype)
 if(isR)i=roundoff(i*i*gf)
 return (iswindata?"from 0 to "+i+" step 2"+(i>1000?"00":""):"[0:"+i+"]")
}
function ylimits(stype,isLD){
 if(isLD)return "from 0 to 50 step 2"
 if(stype=="knots")return "from -6 to 4 step .1"
 if(stype=="km/h")return "from -12 to 8 step .2"
 if(stype=="mph")return "from -6 to 4 step .1"
 if(stype=="ft/min")return "from -600 to 400 step 10"
 if(stype=="ft/s")return "from -12 to 8 step .2" 
 if(stype=="m/s")return "from -3 to 2 step .1"
 return "from -6 to 4 step .1"
}
function ylimits2(stype,isLD){
 if(isLD)return "[0:50]"
 if(stype=="knots")return "[-6:4]"
 if(stype=="km/h")return "[-12:8]"
 if(stype=="mph")return "[-6:4]"
 if(stype=="ft/min")return "[-600:400]"
 if(stype=="ft/s")return "[-12:8]" 
 if(stype=="m/s")return "[-3:2]"
 return "[-6:4]"
}
function xrange(stype){
 if(stype=="knots")return 100
 if(stype=="km/h")return 200
 if(stype=="mph")return 100
 if(stype=="ft/min")return 10000
 if(stype=="ft/s")return 200
 if(stype=="m/s")return 50
 return 100
}
function yrange(stype){
 if(stype=="knots")return 10
 if(stype=="km/h")return 20
 if(stype=="mph")return 10
 if(stype=="ft/min")return 1000
 if(stype=="ft/s")return 20
 if(stype=="m/s")return 5
 return 10
}

function getinfo(){
 usr=document.info 
 hw=getvalue("wind")
 usr.wind.value=hw
 hwdirec=getvalue("hd") % 360
 usr.hd.value=hwdirec
 lift=getvalue("vario")
 liftdirec=getselectof("ld")
 hwunits=getselectof("hu")
 liftunits=getselectof("lu")
 v2kn=toKnots(hwunits)
 l2kn=toKnots(liftunits)
 hwkn=hw*v2kn
 lkn=lift*liftdirec*l2kn
 da=getvalue("da")
 dau=getselectof("dau")
 ismetric=(dau=="m")
 getsigma(da*toFeet(dau))
 aob=getvalue("angleofbank")
 var e=toKnots("m/s")
 vismetric=(hwunits.indexOf("m/")>=0)
 vsismetric=(liftunits.indexOf("m/")>=0)
 e=v2kn*v2kn/e/e*(vismetric?1:3.28084)
 g=9.80665/e
 if(parent.CALC_xy.document.forms.length==0){loadmany();return 0}
 if(!havesetinfo){setinfosource(0);return 0}
 xy=parent.CALC_xy.document.info
 pt=getdataxy()
 if(!havesetinfo){setinfosource(0);return 0}
 var loadunits=strclean(getselectof("wu"))
 var loadtype=getselectof("selloadtype")
 e=getvalue("wingloading")
 if(loadtype=="wingload"){
   if(loadunits=="rel to 1")e=defwingload*toPascals(defwingunits)/toPascals(loadunits)
   wingload=e
   wingunits=loadunits
 }
 if(loadtype=="grosswt"){
   if(loadunits=="rel to 1")e=defgrosswt*toPascals(defwtunits)/toPascals(loadunits)
   grosswt=e
   wtunits=loadunits
 }
 e=roundoff(e,(e<10?2:0))
 sloadinfo=(loadtype=="grosswt"?"Gross Wt":"Wing Loading")+" = "+e+" "+textof("wu")

 return pt
}


function defloading(resetall){
 clearresults()
 if(resetall){
  usr.angleofbank.value=0
  usr.hd.value=0
  usr.wind.value=0
  usr.vario.value=0
  usr.da.value=0
 }
 if(getinfo(0)==0) return 0
 if (!wingOK && !wtOK) usr.wingloading.value=1
 wingload=defwingload
 grosswt=defgrosswt
 wingunits=defwingunits
 wtunits=defwtunits
 putwinginfo()
 setwingunits()
 usr.thisaction.selectedIndex=finditem(usr.thisaction,"showone()",0)
 setcookie(0)
 return 0
}


function windinfo(irange){
 return "Wind from " + fixwind(hwdirec) + " at " + Math.abs(hw) + (irange==0?"":" +/-"+irange)+" " + hwunits
}

function getwinginfo(){
 var s=""
 var s=findvalue(xyinfo,"wingload")
 getxy(s)
 defwingload=(sx==""?0:eval(sx))
 defwingunits=sy
 wingOK=(defwingload>0)
 s=findvalue(xyinfo,"grosswt")
 getxy(s)
 defgrosswt=(sx==""?0:eval(sx))
 defwtunits=sy
 wtOK=(defgrosswt>0)
 loadtype=getselectof("selloadtype")
 if(loadtype=="wingload" && !wingOK)loadtype="grosswt"
 if(loadtype=="grosswt" && !wtOK)loadtype="wingload"
 if(!wtOK && !wingOK){
  usr.wingloading.value=1
  putwinginfo()
  return "Relative Loading = 1"
 }
 var loadunits=strclean(getselectof("wu"))
 if(loadtype=="wingload"){
   if(loadunits=="rel to 1")loadunits=defwingunits
   e=defwingload*toPascals(defwingunits)/toPascals(loadunits)
   wingload=e
   wingunits=loadunits
   grosswt=0
 }
 if(loadtype=="grosswt"){
   if(loadunits=="rel to 1")loadunits=defwtunits
   e=defgrosswt*toPascals(defwtunits)/toPascals(loadunits)
   grosswt=e
   wtunits=loadunits
   wingload=0
 }
 putwinginfo()
 getinfo()
 return sloadinfo
}

function putwinginfo(){
 var iswt=(loadtype=="wingload"?0:1)
 var sselect=""
 var stext=""
 goint=true
 usr.selloadtype.selectedIndex=iswt
 going=false
 if (!wingOK && !wtOK){
  var i=usr.wingloading.value
  if (i>relativeloadmax || i<=0)usr.wingloading.value=1
  setwingunits()
  return
 } 
 setwingunits()
 e=(iswt?grosswt:wingload)
 usr.wingloading.value=roundoff(e,(e<10?2:0))
 var s=(iswt?wtunits:wingunits)
 usr.wu.selectedIndex=finditem(usr.wu,s,"lb")
}

function setwingunits(){
 var f=document.info
 var i=(f.selloadtype[f.selloadtype.selectedIndex].value=='wingload')
 var iu=usr.wingloading.value
 f.wu[0].text=(iu>relativeloadmax?(i?'N/m2':'Pa  '):'rel to 1')
 f.wu[1].text=(iu>relativeloadmax?(i?'kg/m2':'kg  '):'rel to 1')
 f.wu[2].text=(iu>relativeloadmax?(i?'lb/ft2':'lb  '):'rel to 1')

}

function getabcinfo(sinfo,stype,sdef){
 var s=sdef
 var i=sinfo.indexOf(stype+"=")
 if(i>=0)s=sinfo.substring(i+stype.length+1,sinfo.indexOf(";",i))
 return strclean(s)
}

function getabc(){
//  sinkrate = A0*V*V/sqr(Wingload) + B0*V + C0*sqr(Wingload)\
//  or, more generally, A0=P[2] B0=P[1] C0=P[0] and 
//  sinkrate/sqr(Load) = SUM P[i]*(V/sqr(Load)^i

//data format: 

//  P[n] P[n-1] ... P[0];vu=km/hr;vsu=m/s;deg=2;wld=350 N/m2;gwt=800 kg

 sdsrc=xy.data[xy.data.selectedIndex].text
 var sinfo=xy.abc.value+";"
 if(sinfo.indexOf("par=")<0)sinfo="par="+sinfo
 var sabc=getabcinfo(sinfo,"par","0 0 0")+" 0"
 var svunits=getabcinfo(sinfo,"vu","km/h") 
 var svsunits=getabcinfo(sinfo,"vsu","m/s") 
 var ideg=eval(getabcinfo(sinfo,"deg","2"))
 var swingload=getabcinfo(sinfo,"wld","")
 var sgrosswt=getabcinfo(sinfo,"gwt","")
 var isactual=eval(getabcinfo(sinfo,"act","0"))
 var imin=eval(getabcinfo(sinfo,"min","50"))
 getxy(sgrosswt)
 var igrosswt=(sx==""?0:eval(sx))
 wtOK=(igrosswt>0)
 wingOK=!isactual
 var swtunits=(wtOK?sy:"N/m2")
 getxy(swingload)
 var iwingload=(sx==""?0:eval(sx))
 var swingunits=(iwingload?sy:"N/m2")
 var iwingload=(wingOK?(iwingload>0?iwingload:350):1)
 xy.grosswt.value=(wtOK?sgrosswt:"0")
 if (!wingOK && !wtOK) 
 {
  document.info.wingloading.value=1
  xy.wingload.value=0
 }
 if(wingOK)xy.wingload.value=iwingload+" "+swingunits
 for(var i=ideg;i>=0;i--){
  sabc=getxy(sabc)
  sabc=sy+" "+sabc
  P[i]=eval(sx)
 }
 var s=svunits+ " " + svsunits
 
 //table is set for 350 N/m2 wing loading
 var e=(isactual?1:Math.pow(iwingload,0.5))
 for (var V=imin;V<=200;V=V+2){
  var ve=1
  var vfac=V/e
  var sinkrate=0
  for(var i=0;i<=ideg;i++){
   sinkrate+=P[i]*ve 
   ve*=vfac
  }
  sinkrate=sinkrate*e
  s+=" " + V + " " + sinkrate
 }
 return s
}

function dofullanalysis(){
 if(hwdirec==0 || hwdirec==180){
  hwkn=(hwdirec==0?hw:-hw)*v2kn
  analyzedata()
  setfinalvalues()
 }else{
  hwkn=0
  for(var i=1;i<=3;i++){
   analyzedata()
   hwkn=hw*v2kn
   setfinalvalues()
   //three iterations on crosswind, thanks, Jim Hard
   hwkn=vbestLDkn-vGSkn
  }
  hwkn=hw*v2kn
  setfinalvalues()
 }
}

function analyzedata(){
//all in knots
 vsinkstop=1e10
 iminsink=0
 vminsinkkn=0
 minsinkkn=1e10
 vbestLDkn=0
 bestLDsinkkn=0
 bestLDval=0
 ibestLD=0
 Vsi[0]=0
 Vi[0]=0
 var LD=0
 var fval=1

 fval=getvalue("wingloading")
 if(fval>relativeloadmax){
  if(loadtype=="wingload" && wingOK)fval=wingload*toPascals(wingunits)/defwingload/toPascals(defwingunits)
  if(loadtype=="grosswt" && wtOK)fval=grosswt*toPascals(wtunits)/defgrosswt/toPascals(defwtunits)
 }

 fval=Math.pow(fval,0.5)
 var e=rad(aob)
 gf=1/(Math.tan(e)*g)
 e=Math.cos(e)
 fvbank=fval/Math.pow(e,0.5)
 fvsbank=fvbank/e
 for (var i=1;i<=pt;i++){
 var vi=Vi[i]*fvbank
 var vground=vi*toVtrue()-hwkn
 if(vground>1){
  var vs=Vsi[i]*fvsbank*toVtrue()
  var vsink=vs-lkn
  if(vs>vsinkstop) break
  if(vsink==0){
   LD=1e10
  }else{
   LD=vground/vsink
  }
  if(LD<0){
   if(LD>bestLDval || bestLDval>=0){
    ibestLD=i
    bestLDval=LD
    bestLDsinkkn=vsink
    vsinkstop=2*vs
   } 
  }else{
   if(LD>bestLDval && bestLDval>=0){
    ibestLD=i
    bestLDval=LD
    bestLDsinkkn=vsink
    vsinkstop=2*vs
   } 
  }
  if(vsink<minsinkkn){
   iminsink=i
   minsinkkn=vsink
  }
 }
 }
 //all values in knots, adjusted for load and bank
 vminsinkkn=Vi[iminsink]*fvbank*toVtrue()
 vbestLDkn=Vi[ibestLD]*fvbank*toVtrue()
}

function setfinalvalues(){
 //track from wind triangle
 sintheta=Math.sin(rad(hwdirec))
 costheta=Math.cos(rad(hwdirec))
 vGSkn=Math.pow(vbestLDkn*vbestLDkn-hwkn*hwkn*sintheta*sintheta,.5)-hwkn*costheta   
 bestLDval=vGSkn/bestLDsinkkn
 //these are rounded and into units
 vbestLD=roundoff(vbestLDkn/v2kn)
 vminsink=roundoff(vminsinkkn/v2kn)
 vbestLDi=roundoff(vbestLDkn*toVequiv()/v2kn)
 vminsinki=roundoff(vminsinkkn*toVequiv()/v2kn)
 vGS=roundoff(vGSkn/v2kn)
 bestLD=roundoff(bestLDval)
 var r=(liftstepof(liftunits)>1?0:1)
 minsink=roundoff(minsinkkn/l2kn,r) 
 bestLDsink=roundoff(bestLDsinkkn/l2kn,r) 
 vcruise=-1e99
}

function clearresults(){
 $("#graphdiv").hide();
 $("#tablediv").hide();

// parent.CALC_table.document.close()
// parent.CALC_table.document.open()
}

function putresults(){
 dump("<strong>"+sdsrc+"<br>"+sloadinfo+"</strong><br>"+pt+" ("+vunits+","+vsunits+") data points"+resultinfo())
}

function listxy(){
 clearresults()
 if(getinfo(0)==0)return 0
 analyzedata()
 var s = sdsrc + "<br>";
 s +="TRUE speeds for a density altitude of "+getdainfo() + "<br>";
 s +=hwunits + " , " + liftunits + "<br>";
 for(var i=1;i<=pt;i++){
  var v=(Vi[i]*fvbank*toVtrue()-hwkn)/v2kn
  var vs=(Vsi[i]*fvsbank*toVtrue()-lkn)/l2kn
  s+=roundoff(v,4)+ " , "  + roundoff(vs,4) + "<br>";
 }
 showTable(s);
}

function listatm(){
 clearresults()
 getinfo()
 var s = ("Standard Atmosphere") + "<br>"
 if(dau=="ft"){
	imax=15000
	istep=200
 }else{
	imax=5000
	istep=100
 }
 for(var i=0;i<=imax;i+=istep){
  da=i
  getsigma(da*toFeet(dau))
  s +=(getdainfo()) + "<br>"
 }
 showTable(s)
}

function showone() 
{
 if(!havesetinfo){setinfosource(0);return 0}
 clearresults()
 if(getinfo(0)){
  dofullanalysis()
  putresults()
 }
 return 1
}

function setgraphinfo(){
 var i=usr.thisaction.selectedIndex
 var s=usr.thisaction[i].value
 if(s.substring(0,2)!="do") {
  lastGraphType = "";
  return doshow()
 }
 if(s.substring(0,7)!="dograph") return 0
 var gtype=eval(s.substring(s.indexOf("(")+1,s.indexOf(")")))
 if(gtype<10){
  multitype=gtype //save for later
  multipt=i
 }
 return 1
}

var lastGraphType = "";

function dograph(gtype){
 arguments.length > 0 || (gtype = lastGraphType);
 lastGraphType = gtype;
 if (gtype ==="") 
   return;
  
 var itype=usr.sdtype.selectedIndex
 var stype=getselectof("sdtype")
 var isreflect=(stype=="wdt-r")
 iswindata=(stype.indexOf("wdt")==0)

 var irange=0
 clearresults()
 if(getinfo(0)==0)return 0
 if(gtype<10){
  multitype=gtype
  multipt=usr.thisaction.selectedIndex

/*
option value="dograph(0)" Plot Vsink vs. V (Polar)
option value="dograph(1)" Plot L/D vs. V (Performance)
option value="dograph(2)" Plot Vsink vs. R (Turning Polar)
option value="dograph(3)" Plot L/D vs. R (Turning Performance)
option value="dograph(4)" Plot Polar w/ Wind Triangle
*/

 }else{
  irange=gtype
 }
 var ptype=multitype
 var iswind=(ptype==4)
 var isLD=(ptype==1 || ptype==3)
 var isR=(ptype==2 || ptype==3)
 var doall=(ptype==0)
 var aob0=1e99
 var sminfo=""

 if(irange==500)sminfo="da"
 if(irange==500 && da==0){usr.da.value=(ismetric?2000:5000);getinfo()}
 if(irange==15)sminfo="angleofbank"
 if(irange==10)sminfo="wind"
 if(irange==20){irange=2;sminfo="vario"}
 if(irange==50)sminfo="wingloading"
 if(irange==15 && (aob<15 || aob>70)){alert("Angle of Bank is out of range! Setting to 45 temporarily.");aob0=aob;usr.angleofbank.value=45}
 if(isR && aob==0){alert("Angle of bank is 0!");return 0}
 if(pt==0){alert("No data to plot!");return 0}
 if(iswind &&(hwdirec==0 || hwdirec==180 || hwkn==0)){alert("Wind must be nonzero and from an angle for a wind triangle!");return 0} 
 dofullanalysis()
 putresults()
 var sinfo=xlimits(hwunits,isR,true)
 sinfo=getxy(sinfo);xmin=eval(sy)
 sinfo=getxy(sinfo);xmax=eval(sy)
 sinfo=getxy(sinfo);xstep=eval(sy)
 sinfo=ylimits(liftunits,isLD)
 sinfo=getxy(sinfo);ymin=eval(sy)
 sinfo=getxy(sinfo);ymax=eval(sy)
 sinfo=getxy(sinfo);ystep=eval(sy)
 swhat=textof("thisaction")
 swhat=swhat.substring(4,swhat.length)
 if(irange){
  swhat=usr.thisaction[multipt].text+" "+swhat
  swhat=swhat.substring(5,swhat.length)
 }
 var otype=usr.sdtype[itype].value
 sm=""+Math.random()
 sm=sm.substring(3,10)
 s='<!DOCTYPE html><html><body onload=updateGraph()><table><tr><td valign=top><form>'
 s+="<h1>Speed-To-Fly Plot</h1>"
 s+="<h3>"+swhat+"</h3>"
  
// onclick='self.close()'?
 s+="<p>"+pt+ " ("+vunits+","+vsunits+") data points for "+sdsrc+"<br>"+sloadinfo+(irange==50?" +/-50%":"")
 s+=resultinfo()
 //s+="<p><input type=submit value=Plot> <small>Note: If graph doesn't print, try saving it "
 //s+="<br>to your hard disk and opening that local file using your browser."
 //s+="<br>These data may be clipped and placed into a spreadsheet.</small>"
 s+='<br><div style="display:none"><textarea rows=10 cols=75 id="plotTA" name='+(iswindata?(isreflect?"mimeinfo":"xydata"):"_data")+'>'
 var sp="\\n"
 var stitle2=sloadinfo+(irange==50?" +/-50%":"")
 var stitle3="Angle of Bank: "+ aob+(irange==15?" +/-15":"")+" degrees"
 stitle3+=sp+windinfo((irange==10?10:0))+", Lift: "+liftdirec*lift+(irange==2?" +/-2 ":" ")+liftunits
 stitle4="Minimum Sink=" +minsink+" "+liftunits+" at "+vminsink+" "+hwunits+(sigma==1?"":" ("+vminsinki+" indicated)")
 if(isR)stitle4+=", "+roundoff(vminsink*vminsink*gf)+(vismetric?" m":" ft")
 stitle5="Best L/D=" +bestLD+":1 at "+vbestLD+" "+hwunits +(sigma==1?"":"("+vbestLDi+" indicated)")
 if(isR)stitle3+=", "+roundoff(vbestLD*vbestLD*gf)+(vismetric?" m":" ft")
 stitle5+="  Best Vgrd="+vGS+" "+hwunits+" (Vsink="+ bestLDsink+" "+liftunits+")"
 if(sigma!=1)stitle5+=sp+"Density Altitude "+getdainfo()+(irange==50?" +/-50%":"")
 var xunits=(isR?(vismetric?"R(m)":"R(ft)"):"V("+hwunits+")")
 var yunits=(isLD?"L/D":"Vsink("+liftunits+")")
 var shdr = s;
  sep=" "
  nl="\n"
  s="set terminal svg size 800,500 enhanced fname 'arial'  fsize 10 butt solid"+nl
  s+="set output 'out.svg'"+nl
	//s+='set tmargin 10;set bmargin 10;set lmargin 10;set rmargin 10'+nl
	s+='set title "'+swhat+' '+sdsrc+'\\n'+stitle2+'\\n'+stitle3+'"'+nl
	//s+='set data style lines'+nl
	s+='set xlabel "'+xunits+'"'+nl
	s+='set ylabel "'+yunits+'"'+nl
	s+='set xzeroaxis;set tics in'+nl
	s+='set xrange '+xlimits(hwunits,isR,false)+nl
	s+='set yrange '+ylimits2(liftunits,isLD)+nl
 splot=""
 var sld=""
 if(irange) 
 {
  var ival0=eval(eval("usr."+sminfo+".value"))
  var icolor=(iswindata?8421504:0)
  for(var i=1;i<=3;i++){
   var ival=(i==3?0:i*2-3)
   if(ival>=0)icolor=ival*2
   if(!iswindata)icolor=ColorPt[i-1]
   ival=ival0+ival*(irange==50||irange==500?ival0/2:irange)
   swhat="usr."+sminfo+".value="+ival
   eval(swhat)
   getinfo(0)
   dofullanalysis()
   putresults()
   swhat=sminfo+"="+ival
   sld+=curveof(swhat,(i==3 ||irange==15 || irange==50 || irange==500 || isLD),isLD,isR,iswind,icolor,doall)
  } 
  if(aob0!=1e99)usr.angleofbank.value=aob0
  swhat="usr."+sminfo+".value="+ival0
  eval(swhat)  
 }else{
  sld=curveof('',1,isLD,isR,iswind,0,true)
 }
 // splot is created in the eval() call
 s += "\nplot "+splot.substring(1,splot.length)+"\n"
 s += sld;
 $("#plotTA").html(s);
 updateGraph();
  $("#graphdiv").show();
  $("#tablediv").hide();

return 1
/*
 var stail ="</textarea></div></form"+"></td><td>"
   + "<div id=outDiv></div>"
   + "<div id=gnuplotOut></div>"
   + '<div id=gnuplotsvg style="border:1px;width:800px;height:400px"><img style="width:800px;height:500px" id="gnuplotImage"></div>'
   + '<script src="jquery.js"></script>'
   + '<script src="gnuplot_api.js"></script>'
   + '<script src="gui.js"></script>'
   + "</td></tr></table></body></"+"html>"
 newwin=window.open("","CALC_output_"+sm,woptions)
 newwin.document.write(shdr + s + stail);
 newwin.document.close()
 return 1
 */
}
function curveof(swhat,ispolar,isLD,isR,iswind,icolorp,doall){
 var i=0
 var sld=""
 var x=0 //x is v
 var y=0 //y is vsink
 var yoff=(isLD?0:-lkn/l2kn)
 //polar:
 if(ispolar){
 for (var i=1;i<=pt;i=i+1){
  x=Vi[i]*fvbank*toVtrue()
  y=Vsi[i]*fvsbank*toVtrue()
  y=(isLD?(x-hwkn)/(y-lkn):-y/l2kn)
  x=x/v2kn
  if(x>=xmin && x<=xmax && y>=ymin && y<=ymax) 
  {
   if(isR)x=x*x*gf
   sld+=plotxy(x,y,icolorp)
  }
 }
 splot+=",'-' title '"+(swhat.length?swhat:"polar")+"' with lines lt "+Colors[icolorp%Colors.length]
 if(!iswindata)sld+="e\n"
 }
 if(iswindata)sld+=plotxy(1E99,0,0)
 //tangent:
 if(!isR && !isLD){
   var h=(vbestLDkn-vGSkn)*v2kn
   for (var i=0;i<=100;i=i+10){
    x=i/100*(xmax-xmin)+xmin
    var vline=x*v2kn
    var vground=vline-h
    var vsink=vground/bestLDval  //in knots
    y=-vsink/l2kn+yoff
    sld+=plotxy(x,y,(icolorp>0?icolorp:1))
   }
   sld+="e\n";splot+=",'-' title 'tangent' with lines lt "+Colors[icolortangent]
 }
 if(!doall)return sld
 //key speeds:
 x=vbestLDkn/v2kn
 //var vground=vGSkn
 //var vsink=vground/bestLDval  //in knots
 y=(isLD?(vbestLDkn-hwkn)/(bestLDsinkkn):-bestLDsinkkn/l2kn+yoff)
 if(isR)x=x*x*gf
 sld+=plotxy(x,y,1)
 sld+=plotxy(0,y,1)
 sld+=plotxy(x,y,1)
 sld+=plotxy(x,0,1)
 sld+=plotxy(x,yoff,1)
 if(!iswindata){sld+="e\n";splot+=",'-' title '"+stitle5+"' with lines lt "+Colors[icolorbestLD]}
 x=vminsinkkn/v2kn
 if(isR)x=x*x*gf
 y=(isLD?(vminsinkkn-hwkn)/(minsinkkn):-minsinkkn/l2kn+yoff)
 i=32768
 if(iswindata){
  sld+=plotxy(x,yoff,1)
  sld+=plotxy(x,yoff,2)
 }
 sld+=plotxy(x,0,i)
 sld+=plotxy(x,y,i)
 sld+=plotxy(0,y,i)
 sld+=plotxy(x,y,i)
 sld+=plotxy(x,yoff,i)
 if(!iswindata){sld+="e\n";splot+=",'-' title '"+stitle4+"' with lines lt "+Colors[icolorminsink]}
 //wind triangle
 if(iswind){
  sld+=plotxy(0,yoff,0)
  var theta=angleof(hwkn,vbestLDkn,vGSkn,0)
  var hwproj=hw*Math.cos(theta)
  x=hwproj 
  y=hw*Math.sin(theta)/xrange(hwunits)*yrange(liftunits)*aspectratio
  y=Math.abs(y)*(hwdirec>180?1:-1)
  sld+=plotxy(x,y+yoff,0)
  sld+=plotxy(x,yoff,0)
  sld+=plotxy(x,y+yoff,0)
  x=vbestLDkn/v2kn
  sld+=plotxy(x,yoff,0) 
  sld+=plotxy(0,yoff,0) 
 if(!iswindata){sld+="e\n";splot+=",'-' title 'wind triangle' with lines lt "+Colors[icolorwind]}
 }
 return sld
}
 
function dotable(swhat){
 clearresults()
 if(getinfo(0)==0) return 0
 var isxc=(swhat.indexOf("showR")>=0||swhat=="showMac()")
 var sld=""
 var s=""//<html><title>Speed To Fly Calculation</title><body><form>"
 s+="<h2>"+(isxc?"Crosscountry ":"Final Glide ")+"Speed-To-Fly Calculation:</h2>"
 s+="<h3>"+textof("thisaction")+"</h3>"
 s+="<p><strong>"+pt+ " ("+vunits+","+vsunits+") data points for "+sdsrc+"<br>"+sloadinfo
 s+=(isxc?"":swhat.indexOf("showBT")==0?"<br>Lift: "+lift*liftdirec+" "+liftunits:"<br>Angle of Bank: "+aob+" degrees")
 s+="<br>Density Altitude: "+getdainfo()
 if(!isxc)s+="<p>Don't forget a comfortable margin of uncertainty!<p>"
 s+="</strong>"
 sld=eval(swhat)
 s+=sld
// s+="</form"+"></"+"body></"+"HTML>"
// var sm=""+Math.random()
// sm=sm.substring(3,10)
 //newwin=open("","CALC_output_"+sm,woptions)
 //newwin.close()
// newwin=window.open("","CALC_output_"+sm,woptions)
// newwin.document.write(s)
 showTable(s + (swhat.indexOf("showR")>=0 ? speedtable(): "")) 
// newwin.document.write("<a href=javascript:print()>Print</a>")
// newwin.document.close()
 return 1
}

function showTable(s) {
 $("#graphdiv").hide();
 $("#tablediv").html(s).show();
 lastGraphType = "";
}

function ttop(n,sc){
 var s="<table border>"
 s+=TR+THN(2)+hwunits+TD+THN(n)+sc
 return s+TR+THC+"air"+THC+"grd"+THC+"L/D"
}

function showBT(ish){
//x is V; y is aob
//result is V(r,t180,sink)
 var sld="<p>Effect of bank angle on altitude loss in a 180<sup>o</sup> turn at various speeds."
 sld+="<p>V is the INDICATED speed flown in "+hwunits+"."
 if(ish){
  sld+="<br>h is the total altitude loss in "+(vsismetric?"m":"ft")+"."
  sld+="<p>V(h)"
 }else{
  sld+="<br>R is the radius of the turn in "+(vismetric?"m":"ft")+"."
  sld+="<br>t is the time required in seconds."
  sld+="<p>V(R,t)"
 }
 sld+="<table border>"+TR+THC+"Bank"+TH+"VbestLD"+THN(7)+"Speed Above Vminsink ("+hwunits+")"
 sld+=TR+TH+"deg"+TH
 for (var vx=0;vx<=30;vx+=5)sld+=THC+"+"+vx
 hwkn=0
 hwdirec=0
 for (vy=5;vy<89;vy+=5){
  aob=vy
  analyzedata()
  setfinalvalues()
  putresults()
  sld+=TR+THC+vy+TD+RTHof(vbestLDkn/v2kn,1,ish)
  v0=vminsink*toVequiv()
  for (var vx=v0;vx<=v0+30;vx+=5)sld+=(vx==v0 && vy==45?TH:TD)+RTHof(vx*toVtrue(),(vx==v0),ish)
 }
 sld+="</table>"
 if(sigma!=1)sld+="<p>Note: All speeds are INDICATED, not true."
 return sld
}

function RTHof(vin,doi1,ish){
 //vin is TRUE
 var vini=vin*toVequiv()
 var r=vin*vin*gf
 var d=Math.PI*r
 var v1=vin*v2kn/toKnots((vismetric?"m/s":"ft/s"))
 var t=d/v1
 if (doi1)i00=1
 i00=iofvi(i00,vini)
 v1=(Vsi[i00]*fvsbank*toVtrue()-lkn)/toKnots((vsismetric?"m/s":"ft/s"))
 var h=t*v1
 return roundoff(vini)+" ("+(ish?roundoff(h,1):roundoff(r)+", "+roundoff(t))+")"
}

function maccready(climbrate,negsink){
 lift=negsink-climbrate  //generally negative
 lkn=lift*l2kn
 analyzedata()
 setfinalvalues()
 //following based on WWI p.253, displaced 0, and similar triangles 
 return vbestLDkn*climbrate*l2kn/bestLDsinkkn/v2kn
}

function speedtable(){
 var lsep=liftstepof(liftunits)/2
 var sld="<table border>"
 sld+=TR+THN(-2)+"Lift<br>"+liftunits+THN(sigma!=1?3:2)+"minimum sink"+THN(sigma!=1?3:2)+"best L/D"
 if(sigma!=1){
	sld+=TR+THC+"indicated speed<br>"+hwunits+THC+"true speed<br>"+hwunits+THC+"sink rate<br>"+liftunits+THC+"indicated speed<br>"+hwunits+THC+"true speed<br>"+hwunits+THC+"sink rate<br>"+liftunits
 }else{
	sld+=TR+THC+"speed<br>"+hwunits+THC+"sink rate<br>"+liftunits+THC+"speed<br>"+hwunits+THC+"sink rate<br>"+liftunits
 }
 for (var lift=10*lsep;lift>=-10*lsep;lift-=lsep){
  lkn=lift*l2kn
  analyzedata()
  setfinalvalues()
  sld+=TR+THC+lift+TDC+vminsinki+(sigma!=1?TDC+vminsink:"")+TDC+minsink+TDC+vbestLDi+(sigma!=1?TDC+vbestLD:"")+TDC+bestLDsink
 }
 lkn=0
 analyzedata()
 return sld+"</table>"
}

function showRD(isfull){
//itype=1 minsink dolphin, 2 constant speed dolphin, 3 level flight
 aob=0
 hwkn=0
 hwdirec=0
 lkn=0
 analyzedata()
 setfinalvalues()
 putresults()
 dump("calculating...")
 var lmin=minsinkkn/l2kn
 var vmax=Vi[pt]/v2kn
 var v1=0
 var v2=0
 var vcr=0
 var A=new Array()
 var i=0
 var lsep=liftstepof(liftunits)/2
 var sld="<p>The question posed here is this:<p><blockquote><em><b>If there is local stronger lift amid widespread regions of weaker lift (a cloud street) or weak sink, should I:</b></em></blockquote><p><ol>"

 sld+="<li>thermal in the stronger lift and dive through the weaker lift."
 sld+="<li><font color=orange>pull up to minimum sink speed ("+vminsink+" "+hwunits+") in the stronger lift</font> and dive through the weaker lift,"
 sld+="<li>pull up somewhat in the stronger lift and <font color=red>dive to a maximum speed ("+roundoff(vmax)+" "+hwunits+" for this calculation) in the weaker lift</font>,"
 sld+="<li><font color=blue>try to maintain constant airspeed</font>, or" 
 sld+="<li><font color=green>try to maintain constant altitude</font>?"
 sld+="</ol><p>The answer to this question is not at all obvious and depends upon the strength and extent of the stronger and weaker lift."

 sld+="<p>The calculation compares each of these possibilities for a wide range of possible combinations of strong and weak lift."

 sld+="<p>In this table the first column is the weaker lift(+) or sink(-)."
 sld+=" The second column is the stronger lift."
 sld+="<br>The third column shows speeds that would be required for thermalling in the stronger lift (assuming it has a small extent) and gliding through the weaker lift/sink (MacCready calculation)."
 sld+=" Other column headings are the percentage of the route that is in stronger lift."
 sld+="<br>In each cell, three speeds are the indicated:<ul><li>the indicated speed to fly in the weaker lift,<li>the indicated speed to fly in the stronger lift, and<li>the average speed (true).</ul>"

 sld+="<p>Here are some of the conclusions I get from these calculations:<ol>"
 sld+="<li>Thermalling is only required when the weaker lift is less than about minimum sink ("+minsink+" "+liftunits+"). Even then, thermalling is only necessary when the stronger lift is still fairly weak or there is a moderate amount of it."
 sld+="<li>When there are only occasional regions of strong lift, it is generally best to <font color=blue>maintain a constant airspeed</font>. This will result in dolphin flight, rising in the stronger lift and falling in the weaker lift."
 sld+="<Li>When more than about half of the route is strong lift, and the stronger lift is LESS THAN TWICE AS STRONG as the weaker lift, then it is generally better to fly EVEN FASTER through it, backing off in weaker lift, so as to <font color=green>maintain constant altitude</font>. This result was a total surprise to me."
 sld+="<Li>When more than about half of the route is strong lift, and the stronger lift is AT LEAST TWICE AS STRONG as the weaker lift, then it is generally better to fly <font color=red>as fast as possible through the weaker lift</font>. That is, <em>when the strong lift is a lot stronger than the weak lift, and there is a lot of strong lift, dive as fast as possible through the weaker lift.</em>"
 sld+="<li>Only in rare borderline cases (when there is a fair amount of sink and thermalling is nearly required) is it best to fly at <font color=orange>minimum sink speed in the strong lift</font>."
 sld+="</ol><p><table border>"+TR+THN(-2)+"Weaker Lift<br>"+liftunits+THN(-2)+"Stronger Lift<br>"+liftunits+THN(-2)+"thermal/<br>glide"+THN(9)+"Percent of Route in Stronger Lift"
 sld+=TR
 for (var f=10;f<100;f+=10)sld+=THC+f+"%"

 for (var lift2=8*lsep;lift2>-2*lmin;lift2-=lsep){
  for (var lift1=10*lsep;lift1>=lift2 && lift1>lmin;lift1-=lsep){
   vcr=maccready(lift1-lmin,lift2)
//when vcr>vbestLDi then MacCready calc fails
   A[i++]=(vcr>vbestLDi?"":vbestLDi+" "+vminsinki+" "+roundoff(vcr))
  }
 }
 lkn=0
 analyzedata()
 setfinalvalues()
 var i=0
 var s=""
 var fc="red"
 var d1_d2=0
 var isstar=false
 for (var lift2=8*lsep;lift2>-2*lmin;lift2-=lsep){
  if(i)sld+=TR+THN(12)+"&nbsp;"
  for (var lift1=10*lsep;lift1>=lift2 && lift1>lmin;lift1-=lsep){
   sld+=TR+THC+lift2+THC+lift1
   for (var f=0;f<100;f+=10){
	s="thermal"
	star=""
	fc="orange"
	d1_d2=f/(100-f)
	//red minsink dolphin
	var v11=vminsinkkn/v2kn
	var v21=vofdoverl((lift1*l2kn-minsinkkn)/vminsinkkn*d1_d2,-lift2)
	if(v21==0){
		fc="red"
		v21=Vi[pt] //max it out!
		v11=vofdoverl(-(Vsi[pt]*toVtrue()-lift2)/v21/d1_d2,-lift1)
	}
	if(v21==0 || v11==0){
		fc="darkred"
		v21=vofbestld(lift2)
		v11=vofdoverl(-(Vsi[pt]*toVtrue()-lift2)/v21/d1_d2,-lift1)
	}
	var vcr1=(d1_d2+1)/(d1_d2/v11+1/v21)
	//blue constant speed dolphin--only possible when
	var v12=vofsink(lift1-d1_d2*(lift1-lift2))
	var v22=v12
	var vcr2=(d1_d2+1)/(d1_d2/v12+1/v22)
	//green level flight--not possible unless both lifts are >minsink
	var v13=vofsink(lift1)
	var v23=vofsink(lift2)
	vcr3=(d1_d2+1)/(d1_d2/v13+1/v23)
	vcr=Math.max(Math.max(vcr3,vcr2),vcr1)
	if(vcr==vcr1){
		if((vcr1-vcr3)*v2kn<1){isstar=true;star="*";vcr=vcr3}
		v1=v11
		v2=v21
	}
	if(vcr==vcr3){
		fc="green"
		v1=v13
		v2=v23
	}
	if(vcr==vcr2){
		fc="blue"
		v1=v12
		v2=v22
	}
	if(vcr!=0)s=roundoff(v2)+" "+roundoff(v1)+" "+roundoff(vcr*toVtrue())+star
	sld+=TD+(f==0?A[i++]:vcr==0?s:"<font color="+fc+">"+s+"</font>")
	if(isfull && f){
		sld+="<br>"+roundoff(v21)+" "+roundoff(v11)+" "+roundoff(vcr1*toVtrue())
		sld+="<br>"+roundoff(v22)+" "+roundoff(v12)+" "+roundoff(vcr2*toVtrue())
		sld+="<br>"+roundoff(v23)+" "+roundoff(v13)+" "+roundoff(vcr3*toVtrue())
	}
   }
  }
 }
 sld+="</table>"
 if(isstar)sld+="*For these entries, flying slower in the strong lift and faster in the weak lift gave an average speed slightly better (within 1 knot)."
 dump("...done "+sld.length)
 return sld
}

function showMac(){
//x is inter-thermal sink; y is thermal lift
//result is STF for maximum cruise speed
 
 liftdirec=1 
 aob=0
 hwkn=0
 hwdirec=0
 var lsep=liftstepof(liftunits)/2
 var sld="<p>Left column is observed or expected climb rate in "+liftunits+" while soaring in thermal lift."
 sld+="<br>Other column headings are lift (sink when < 0) encountered between thermals."
 sld+="<p>Vi is INDICATED speed to fly between thermals."
 sld+="<br>Vcruise is TRUE average air speed including soaring and gliding."
 sld+="<p>Vi (Vcruise) in "+hwunits

 sld+="\n<table border>"+TR+THC+"Climb Rate"+THN(10)+"Lift Encountered During Glide ("+liftunits+")"
 sld+=TR+THC+liftunits
 for (var si=lsep;si>-8.5*lsep;si-=lsep)sld+=THC+si
 for (var cl=12*lsep;cl>0;cl-=lsep){
  sld+=TR+THC+cl
  for (var si=lsep;si>-8.5*lsep;si-=lsep){
   vcruise=maccready(cl,si)
   putresults()
   sld+=TD+vbestLDi+" ("+roundoff(vcruise)+")"
  }
 }
 sld+="</table>"
 return sld
}

function showLW(isrange) 
{ 
 liftdirec=1 
 var sld="speed to fly in "+hwunits+" indicated "
 if(isrange){
  if(isrange==1){
   sld+="(range in "+(vismetric?"km":"statute miles")
   var fhval=1/toKnots((vismetric?"km/h":"mph"))
   sld+=" per 100"+(vsismetric?" meters":"0 feet")+" altitude loss)"
   fhval=fhval*(vsismetric?toKnots("km/h")/10:toKnots("mph")/5.28)
  }else{
   sld+="(altitude loss in "+(vsismetric?"m":"ft")
   fhval=(vsismetric?1/toKnots("km/h"):5.28/toKnots("mph"))
   sld+=" for every 10 "+(vismetric?" km":"statute miles")+" traveled)"
   fhval=fhval*10000*toKnots((vismetric?"km/h":"mph"))
  }
 }else{
  sld+="(Lift:Drag) sink rate in "+liftunits
 }
 sld="<p>"+sld+"<table border>"
 sld+=TR+THN(2)+THN(3)+"Tailwinds"+TH+hwunits+THN(3)+"Headwinds"
 sld+=TR+THN(2)
 for (var hx=-30;hx<=30;hx=hx+10)sld+=TH+Math.abs(hx)
 var lsep=liftstepof(liftunits)
 for (var l=2*lsep;l>=-5*lsep;l=l-lsep){
  sld+=TR
  var s=""
  if(l==2*lsep)s="<TH rowspan=2>Lift"
  if(l==0)s=TH+liftunits
  if(l==-lsep)s="<TH rowspan=5>Sink"
  //if(s=="")s="<TD>"
  sld+=s+TH+Math.abs(l)
  hwdirec=0
  for (var hx=-30;hx<=30;hx=hx+10){
   if(hx==0 || l==0){ttype=THC}else{ttype=TDC}
   hwkn=hx*v2kn
   lift=l
   lkn=lift*l2kn
   analyzedata()
   setfinalvalues()
   putresults()
   sld+=ttype+vbestLDi
   if(isrange){
    sld+=" ("+(isrange==1?roundoff(bestLDval*fhval,1):roundoff(fhval/bestLDval))+")"
   }else{
    sld+=" ("+bestLD+":1) "+ bestLDsink
   }
  }
 }
 sld+="</table>"
 if(sigma!=1)sld+="<p>Note: Speeds for lift, sink, and wind are TRUE SPEEDS whereas speeds to fly are INDICATED."
 return sld
}

function showWD(){
 return showWD_("Head")+showWD_("Tail")
}

function showWD_(stype){
 //y is wind strength; x is wind direction; result is hw/crab
 var y0=5
 var y1=-1
 var ystep=-1
 var x0=0
 var x1=100
 var xstep=10
 var istail=(stype=="Tail")
 if(istail){
  y0=0
  y1=-6
  ystep=-1
  x0=180
  x1=80
  xstep=-10
 }
 var stepval=hwmax(hwunits)/5
 sld="<p>Values are wind speed in "+hwunits+"/required crab angle."
 sld+=ttop(10,"Relative "+stype+"wind Direction")
 for (var x=x0;x!=x1;x+=xstep)sld+=THC+fixwind(x)
 for (var y=y0;y!=y1;y+=ystep){
   hwkn=y*stepval*v2kn
   hwdirec=0
   analyzedata()
   setfinalvalues()
   putresults()
   sld+=TR+TH+vbestLDi+TH+vGS+TH+bestLD+":1"
   for (var x=x0;x!=x1;x+=xstep){
    hwkn=adjsideof(vGSkn,vbestLDkn,180-x,1)
    if(hwkn<0.00001) hwkn=0
    var crab=angleof(vbestLDkn,vGSkn,hwkn,1)
    var ttype="<"+(x==x0||y==0?"th":"td")+" align=center nowrap>"
    sld+=ttype+(crab==-99999?"":roundoff(hwkn/v2kn)+"/"+fixwind((istail?360-crab:crab)))
   }
  }
  sld+="</table>"
  sld+="Air speeds are INDICATED; ground and wind speeds are TRUE"
  return sld
}
function showCrab(){
 //y is wind strength; x is crab angle; result is hwdir @ hw

 var y0=5
 var y1=-6
 var ystep=-1

 var x0=0
 var x1=100
 var xstep=10

 var stepval=hwmax(hwunits)/5

 var sld="<p>Equivalent crosswinds for a given optimum speed to fly and resulting best L/D are given under headings of the crab required to maintain the desired track."
 sld+=" All speeds are in "+hwunits +"."
 hwdirec=0
 hwkn=25*v2kn
 analyzedata()
 setfinalvalues()
 hwkn=oppsideof(vGSkn,vbestLDkn,10,1)
 hwdirec=angleof(hwkn,vbestLDkn,vGSkn,1)
 sld+="<p>For example, fly straight at "+vbestLDi+" "+hwunits+" (indicated) with a ground track speed of "+vGS+" "+hwunits +" for a headwind of 25 "+hwunits+" (000 @ 25) "
 sld+="OR with a crab of 10 degrees into the wind for a wind from "+fixwind(hwdirec)+" at "+roundoff(hwkn/v2kn)+ " "+hwunits+" (" +fixwind(hwdirec)+" @ "+roundoff(hwkn/v2kn)+")."
 sld+=" You will then have the best L/D for these conditions, "+bestLD+":1."
 sld+="<p>Values are relative wind @ wind speed in "+hwunits
 sld+=ttop(10,"Crab Angle (degrees)")
 for (var x=x0;x!=x1;x+=xstep)sld+=TH+fixwind(x)
 for (var y=y0;y!=y1;y+=ystep){
   hwkn=y*stepval*v2kn
   hwdirec=0
   analyzedata()
   setfinalvalues()
   putresults()
   sld+=TR+TH+vbestLDi+TH+vGS+TH+bestLD+":1"
   for (var x=x0;x!=x1;x+=xstep){
     var crab=x
     hwkn=oppsideof(vGSkn,vbestLDkn,crab,1)
     hwdirec=angleof(hwkn,vbestLDkn,vGSkn,1)
     var ttype="<"+(x==x0||y==0?"th":"td")+" align=left nowrap>"
     sld+=ttype+(hwdirec<-360?"":fixwind(hwdirec)) +" @ "+roundoff(hwkn/v2kn)
   }
  }
  sld+="</table>"
  sld+="Air speeds are INDICATED; ground and wind speeds are TRUE"
  return sld
}

function showWS(){
 //y is wind strength; x is wind speed; result is rel wind/crab
 var y0=5
 var y1=-6
 var x0=0
 var x1=9
 var xstep=1
 var ystep=-1
 var stepval=hwmax(hwunits)/5
 sld="<p>Values are relative wind direction/required crab angle"
 sld+=ttop(9,"Wind Strength ("+hwunits+")")
 for (var x=x0;x!=x1;x+=xstep)sld+=TH+x*stepval
 for (var y=y0;y!=y1;y+=ystep){
   hwkn=Math.abs(y*stepval)*v2kn
   hwdirec=(y>=0?0:180)
   analyzedata()
   setfinalvalues()
   putresults()
   sld+=TR+TH+vbestLDi+TH+vGS+TH+bestLD+":1"
   for (var x=x0;x!=x1;x+=xstep){
     hwkn=x*stepval
     hwdirec=180-angleof(hwkn,vGSkn,vbestLDkn,1)
     var crab=angleof(vbestLDkn,vGSkn,hwkn,1)
     var ttype="<"+(x==x0||y==0?"th":"td")+" nowrap>"
     sld+=ttype+(crab<0||hwdirec>360?"":fixwind(hwdirec)+"/"+fixwind(crab))
   }
  }
  sld+="</table>"
  sld+="Air speeds are INDICATED; ground and wind speeds are TRUE"
  return sld
}


function resultinfo(){
 var s=""
 s+="<br>Angle of Bank: "+aob+" degrees"
 s+="<br>"+windinfo(0)+"; Lift "+liftdirec*lift+" "+liftunits
 s+="<br>Density Altitude: "+getdainfo()
 s+="<br>Minimum Sink " +minsink+" "+liftunits+" at "+vminsink+" "+hwunits +(sigma==1?"":" true ("+vminsinki+" indicated)")
 s+="<br>Best L/D " +bestLD+":1 at "+vbestLD+" "+hwunits +(sigma==1?"":" true ("+vbestLDi+" indicated)")
 if(vcruise==-1e99){
  s+="<br>Best Vgrd="+vGS+" "+hwunits+" (Vsink="+ bestLDsink+" "+liftunits+")"
 }else{
  s+="<br>Best Vcruise="+roundoff(vcruise)+" "+hwunits
 }
 return s+"<p>"
}

